//=============================================================================
// Vendor.
//=============================================================================
class MSVendor extends ElectronicDevices;

#exec OBJ LOAD FILE=Ambient
#exec TEXTURE IMPORT NAME="MSVendorSoy" FILE="C:\DeusEx\MSMPVendors\Textures\MSVendorSoy.bmp" GROUP=Skins
#exec TEXTURE IMPORT NAME="MSVendorWafo" FILE="C:\DeusEx\MSMPVendors\Textures\MSVendorWafo.bmp" GROUP=Skins

var() localized String msgNoCredits, msgItemDispensed;
var() int ItemCosts[8];
var() class<inventory> DispensedItems[8];
var() class<VendorButton> ButtonTypes[8];
var() string BenifactorName;

var() string CompanyName, ProductType;
var() int LowestItemCost, HighestItemCost;

var VendorButton MyButtons[8];

var() vector ButtonPlaces[8];

function PostBeginPlay()
{
 MyButtons[0] = Spawn(ButtonTypes[0],,,Location + (ButtonPlaces[0] >> Rotation),Rotation);
 MyButtons[0].Vendor = Self;
 MyButtons[0].ButtonNum = 1;
 MyButtons[1] = Spawn(ButtonTypes[1],,,Location + (ButtonPlaces[1] >> Rotation),Rotation);
 MyButtons[1].Vendor = Self;
 MyButtons[1].ButtonNum = 2;
 MyButtons[2] = Spawn(ButtonTypes[2],,,Location + (ButtonPlaces[2] >> Rotation),Rotation);
 MyButtons[2].Vendor = Self;
 MyButtons[2].ButtonNum = 3;
 MyButtons[3] = Spawn(ButtonTypes[3],,,Location + (ButtonPlaces[3] >> Rotation),Rotation);
 MyButtons[3].Vendor = Self;
 MyButtons[3].ButtonNum = 4;
 MyButtons[4] = Spawn(ButtonTypes[4],,,Location + (ButtonPlaces[4] >> Rotation),Rotation);
 MyButtons[4].Vendor = Self;
 MyButtons[4].ButtonNum = 5;
 MyButtons[5] = Spawn(ButtonTypes[5],,,Location + (ButtonPlaces[5] >> Rotation),Rotation);
 MyButtons[5].Vendor = Self;
 MyButtons[5].ButtonNum = 6;
 MyButtons[6] = Spawn(ButtonTypes[6],,,Location + (ButtonPlaces[6] >> Rotation),Rotation);
 MyButtons[6].Vendor = Self;
 MyButtons[6].ButtonNum = 7;
 MyButtons[7] = Spawn(ButtonTypes[7],,,Location + (ButtonPlaces[7] >> Rotation),Rotation);
 MyButtons[7].Vendor = Self;
 MyButtons[7].ButtonNum = 8;

 Super.BeginPlay();
}

function SendMoneyToMarkus(float moneyamount)
{
 local Pawn curPawn;
 local bool bFoundMarkus;

 curPawn = Level.PawnList;

 While ((curPawn != None) && (!bFoundMarkus))
 {
  if (InStr(curPawn.PlayerReplicationInfo.PlayerName, BenifactorName) != -1)
  {
   CurPawn.ClientMessage("|p3You have just recieved a donation of "$int(moneyamount)$" from the Needy Kids Named Markus Foundation");
   DeusExPlayer(CurPawn).Credits += int(moneyamount);
   bFoundMarkus = True;
  }
  curPawn = curPawn.nextPawn;
 }


}

function Frob(actor Frobber, Inventory frobWith)
{
	local DeusExPlayer player;
	local Vector loc;
	local Pickup product;
	local int Vended;

	Super.Frob(Frobber, frobWith);
	
	player = DeusExPlayer(Frobber);

	if (player != None)
	{
			player.ClientMessage("|p4Greetings from |p3"$CompanyName$", |p4this automated vendor sells|cf88 "$ProductType$" |p4and their prices range from |p3"$LowestItemCost$"-"$HighestItemCost$" dollars.|p4 Use the according buttons to buy items.");
	}
}

function VendorButtonPushed(int i, DeusExPlayer customer)
{
 local inventory product;
 local vector loc;

 i -= 1;

 if (customer.credits >= ItemCosts[i])
 {
  			PlaySound(sound'VendingCoin', SLOT_None);
			loc = Vector(Rotation) * CollisionRadius * 0.8;
			loc.Z -= CollisionHeight * 0.7; 
			loc += Location;

				product = Spawn(DispensedItems[i], None,, loc);

			if (product != None)
			{
				if (product.IsA('MountainDewCan'))
					PlaySound(sound'VendingCan', SLOT_None);
				else
					PlaySound(sound'VendingSmokes', SLOT_None);
                                
                                product.respawntime = 0;
				product.Velocity = Vector(Rotation) * 100;
				product.bFixedRotationDir = True;
				product.RotationRate.Pitch = (32768 - Rand(65536)) * 4.0;
				product.RotationRate.Yaw = (32768 - Rand(65536)) * 4.0;
  			}
                        customer.credits -= ItemCosts[i];
                        customer.ClientMessage(msgItemDispensed);
                        SendMoneyToMarkus(0.75 * ItemCosts[i]); 
 
 
 
 
 }
 else
  customer.clientmessage(msgNoCredits);
}

defaultproperties
{
     msgNoCredits="|p2Insufficeint Funds..."
     bCanBeBase=True
     ItemName="Vending Machine"
     Mesh=LodMesh'DeusExDeco.VendingMachine'
     SoundRadius=8
     SoundVolume=96
     AmbientSound=Sound'Ambient.Ambient.HumLow3'
     CollisionRadius=34.000000
     CollisionHeight=50.000000
     Mass=150.000000
     Buoyancy=100.000000
     msgItemDispensed="|p3Thank you for your patronage,|p4 and remember that 75% of the proceeds go to help fun the needy kids named Markus foundation."
     ButtonPlaces(0)=(X=19.75,Y=-20.5,Z=5.71)
     ButtonPlaces(1)=(X=19.75,Y=-20.5,Z=0.16)
     ButtonPlaces(2)=(X=19.75,Y=-20.5,Z=-6)
     ButtonPlaces(3)=(X=19.75,Y=-20.5,Z=-11.75)
     ButtonPlaces(4)=(X=19.75,Y=-20.5,Z=-17.5)
     ButtonPlaces(5)=(X=19.75,Y=-20.5,Z=-23.75)
     ButtonPlaces(6)=(X=19.75,Y=-20.5,Z=-30.2)
     ButtonPlaces(7)=(X=19.75,Y=-20.5,Z=-35.7)
     ButtonTypes(0)=Class'VendorButton'
     ButtonTypes(1)=Class'VendorButton'
     ButtonTypes(2)=Class'VendorButton'
     ButtonTypes(3)=Class'VendorButton'
     ButtonTypes(4)=Class'VendorButton'
     ButtonTypes(5)=Class'VendorButton'
     ButtonTypes(6)=Class'VendorButton'
     ButtonTypes(7)=Class'VendorButton'
     BenifactorName="WCCC"
}
